import { StarXpandCommand } from "star-io10-web";

export class LabelSample09_For203dpiAnd300dpi_FoodPrepLabel {
  static async createPrintCommands(): Promise<string> {
    let builder = new StarXpandCommand.StarXpandCommandBuilder();

    builder.addDocument(
      new StarXpandCommand.DocumentBuilder().addPrinter(
        new StarXpandCommand.PrinterBuilder()
          .add(
            new StarXpandCommand.PrinterBuilder()
              .styleAlignment(StarXpandCommand.Printer.Alignment.Right)
              .styleBold(true)
              .styleMagnification(
                new StarXpandCommand.MagnificationParameter(2, 2),
              )
              .actionPrintText("WEDNESDAY\n"),
          )
          .styleAlignment(StarXpandCommand.Printer.Alignment.Left)
          .actionPrintText("Product\n")
          .add(
            new StarXpandCommand.PrinterBuilder()
              .styleMagnification(
                new StarXpandCommand.MagnificationParameter(2, 2),
              )
              .actionPrintText("Lettuce\n"),
          )
          .actionPrintText("Prepared On\n")
          .add(
            new StarXpandCommand.PrinterBuilder()
              .styleMagnification(
                new StarXpandCommand.MagnificationParameter(2, 2),
              )
              .actionPrintText("3/24/2021\n"),
          )
          .actionPrintText("Used by\n")
          .add(
            new StarXpandCommand.PrinterBuilder()
              .styleMagnification(
                new StarXpandCommand.MagnificationParameter(2, 2),
              )
              .actionPrintText("3/25/2021\n"),
          )
          .actionPrintRuledLine(
            new StarXpandCommand.Printer.RuledLineParameter(48.0),
          )
          .actionPrintText("User: A. Star   Manager: M. Star\n")
          .actionCut(StarXpandCommand.Printer.CutType.Partial),
      ),
    );

    return await builder.getCommands();
  }
}
